#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Planet OrbitMod01.fsh  by   jeffbustercase  
//https://www.shadertoy.com/view/dsjfzz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define MOUSE_ROTATE_PLANET false
#define SUN_ROTATION false
#define ROTATE_CAMERA false
#define MOUSE_ROT false
#define ACES true
#define FILMIC false
#define TONEMAP_TEST false
#define AA 6  //2

#define t iTime*0.4
#define res iResolution


mat4 rotateY(float theta) {
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(c, 0, s, 0),
        vec4(0, 1, 0, 0),
        vec4(-s, 0, c, 0),
        vec4(0, 0, 0, 1)
    );
}

mat4 rotateX(float theta) {
  float s = sin(theta);
  float c = cos(theta);

  return mat4(
    vec4(1.0, 0.0, 0.0,0.0),
    vec4(0.0,   c,   s,0.0),
    vec4(0.0,  -s,   c,0.0),
    vec4(0.0,   0,   0,1.0)
  );
}

mat4 rotateZ(float theta) {
  float s = sin(theta);
  float c = cos(theta);

  return mat4(
    vec4( c,   s, 0.0,0.0),
    vec4(-s,   c,   0,0.0),
    vec4(0.0,  0,   1,0.0),
    vec4(0.0,  0,   0,1.0)
  );
}

mat4 rotMat(vec3 r) {
	return rotateX(r.x)*rotateY(r.y)*rotateZ(r.z);
}

vec3 rotateByMouse(vec3 entryPoint)
{
	float mf = 10.;
    float mx = -(iMouse.x/iResolution.x*2.-1.)*mf;
    float my = (iMouse.y/iResolution.y*2.-1.)*mf*.5;
    vec2 vv = vec2(mx,my);
    float v = distance(vv/4.,vec2(0));
    return (vec4(entryPoint,1.0)*rotMat(vec3(0,v,0))).xyz;
}

vec3 getPos(int id) {
	if(id==2) {
		return vec3(0);
	} else if (id==0) {
		return vec3(0.2,0,0);
	} else {
		return vec3(-.5,0,0);
	}
}

vec3 pos(vec3 p, int id)
{
    return p+getPos(id);
}

mat4 baseMat(vec3 pos) {
	return mat4(
        vec4(1, 0, 0, pos.x),
        vec4(0, 1, 0, pos.y),
        vec4(0, 0, 1, pos.z),
        vec4(0, 0, 0, 1)
    );
}

mat4 posMat(int id) {
	vec3 pos = getPos(id);
	return baseMat(pos);
}

// From IQ Articles page
vec4 boxmap( in sampler2D s, in vec3 p, in vec3 n, in float k )
{
    // project+fetch
    vec4 x = texture2D( s, p.yz );
    vec4 y = texture2D( s, p.zx );
    vec4 z = texture2D( s, p.xy );
    
    // blend weights
    vec3 w = pow( abs(n), vec3(k) );
    // blend and return
    return (x*w.x + y*w.y + z*w.z) / (w.x + w.y + w.z);
}



// Free real state?
vec3 acesFilm(const vec3 x) {
    const float a = 2.51;
    const float b = 0.03;
    const float c = 2.43;
    const float d = 0.59;
    const float e = 0.14;
    return clamp((x * (a * x + b)) / (x * (c * x + d ) + e), 0.0, 1.0);
}

// ..Somehow..
vec3 tonemapFilmic(const vec3 color) {
	vec3 x = max(vec3(0.0), color - 0.004);
	return (x * (6.2 * x + 0.5)) / (x * (6.2 * x + 1.7) + 0.06);
}


float sdf(vec3 p, int id) {
	
    if(id == 0)
    {
        return length(p)-.75;
    } else 
    {
        return length(p)-.326;
    }
}

vec3 rotVec(int id) {
	if(id == 0) {
		return vec3(0,0.5*t,0);
	} else {
		return vec3(0.0,0.2*t,0);
	} 
}

vec3 rotate(vec3 rotV, vec3 p) {
	return ((rotMat(rotV)) * vec4(p,1.0)).xyz;
}

vec3 translate(vec3 p, int id) {
	if(id == 0) {
		return vec3(0)+p;
	} else  {
		return vec3(1.5,0,1.5)+p;
	} 
}

vec3 rotateToWorld(vec3 p, int id)  {
	if(id == 0) {
		return p;
	} else {
		if(MOUSE_ROTATE_PLANET)
			return rotateByMouse(p);
		else
			return rotate(vec3(0,0.5*t,0),p);
	}
}

vec3 transform(vec3 p, int id) {
	p = rotateToWorld(p, id);//must come before translation
	p = translate(p, id);
	vec3 rotV = rotVec(id);
	vec3 r = rotate(rotV, p);
	return r;
}

float sd(vec3 p, int id)
{
	vec3 r = transform(p,id);
	return sdf(r,id);
}

vec3 doMaterial(vec3 p, vec3 nor, int id)
{
  
    if(id == 0)
    {   
        return boxmap(texture0, p, nor, 8.0).xyz;    
    } else 
    {
        return boxmap(texture1, p, nor, 8.0).xyz;    
    }
}

vec3 render(vec2 uv)
{
    
    vec3 col = vec3(0);
    vec3 lightColor = vec3(.86,.9,.65);
    
    vec3 light = vec3(1.6,-0.4,-3.2);
    if(SUN_ROTATION) {
	    light = (vec4(light,1.0)*rotMat(vec3(0.0,2.0*-0.91*t,0.0))).xyz;
    }
    
    vec3 ro = vec3(2.0,-.3,-2.525);
    
    if(ROTATE_CAMERA) {
	    ro = (vec4(ro,1.0)*rotMat(vec3(0,0.91*t,0))).xyz;
    }
    
    if(MOUSE_ROT && iMouse.z > 0.)
    {
        ro = rotateByMouse(ro);
    }
    
    vec3 lookAt = vec3(0);
    
    float vel = 1.;
    float mov = vel*1.;
    
    
    
    float focal = 1080.;
    //float focal = 300.;
    //vec2 coord = uv * iResolution.xy*.7;
    vec2 coord = uv * iResolution.xy*.5;
    vec3 camDir = normalize(lookAt-ro);
    vec3 center = ro + camDir * focal;
    
    vec3 zpos = -camDir;
    vec3 xpos = cross(vec3(0,1,0),zpos);
    vec3 ypos = cross(xpos,zpos);
    
    vec3 target =
        center
        + xpos * coord.x
        + ypos * coord.y;
    
    vec3 rd = normalize(target-ro);
    
    const int MAX_REFL = 10;
    
    const float EPS = 0.005;
    float depth = EPS;
    for(int i=0;i<256;i++)
    {
        vec3 p = ro + depth*rd;
        vec3 bkp = p;
        float dis0 = sd(p,0);
        float dis1 = sd(p,1);
        
        int id = -1;
        float dis = EPS;
        if(dis0<dis1) {
        	id = 0;
        	dis = dis0;
        }
        else {
			dis = dis1;
			id=1;
        }
        
        if(dis < EPS)
        {


            vec2 eps = vec2(1,-1);
            
            vec3 nor = normalize( eps.xyy*sd( p + eps.xyy*EPS,id ) + 
                      eps.yyx*sd( p + eps.yyx*EPS,id ) + 
                      eps.yxy*sd( p + eps.yxy*EPS,id ) + 
                      eps.xxx*sd( p + eps.xxx*EPS,id ) );
	       	p = transform(p,id);
	       	
            vec3 toLight = normalize(light-p);            

            float diff = dot(toLight,nor);
            
            float ambient = 0.0035;
            vec3 color = vec3(1.);
            
            color = doMaterial(p,nor,id);
            vec3 shadowedColor = color*ambient;
            col *= shadowedColor;
            if(diff > EPS)
            {
                vec3 preCol = color * diff * lightColor;
                preCol *= 1./distance(light,p);
                
                col += preCol;
            }
            
            //apply shadow if so
            float colforc = 1.;
            float _depth = EPS;
            float k = 3.;
            vec3 orig = bkp+toLight*EPS*7.;
            for(int j=0;j<65;j++)
            {
            	//break;
                vec3 _p = orig+_depth*toLight;
                
                float _dis0 = sd(_p,0);
                float _dis1 = sd(_p,1);
                
                int _id = -1;
				float _dis = EPS;
                if(_dis0<_dis1){
	                _id=0;
	                _dis = _dis0;
                }
                else {
	                _id = 1;
	                _dis = _dis1;
                }
               
                
                if(_dis<EPS)
                {             	
                    colforc = ambient;
                    break;
                }
                
                colforc = max(min(colforc, k*_dis/_depth),ambient);
                _depth += _dis;
                
                if(_dis>20.)
                {
                    break;
                }
            }
            
            col *= colforc;
            break;
        }
        
        depth += dis;
        
        if(dis > 2000.)
        {
            col += vec3(0.3,.6,.9) * (1.-length(uv*.6))*0.01;
          
            break;
        }
    }
    
    return col;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/res.xy*2.-1.;

    vec3 col = vec3(0);
    
    const int lim = AA;
    vec2 st = uv;
    for(int i=0;i<lim;i++)
    {
        float f = float(i);
        col += render(st);
        st.x += 0.00075*sin(uv.x*f+f);
        st.y += 0.00075*cos(uv.y*f+f);
    }
    
    col = col/float(lim);
    
    if(ACES) col = acesFilm(col);
    if(FILMIC) col = tonemapFilmic(col);
    
    
    if(TONEMAP_TEST){
	    if(uv.x > 0. && uv.y > 0.) col = acesFilm(col);
	    else if(uv.x < 0. && uv.y < 0.) col = tonemapFilmic(col);
	    else if(uv.x > 0. && uv.y < 0.) col = tonemapFilmic(acesFilm(col));
    }
    
    col = pow(col,vec3(.4545));

    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

